<?php
const API_URL = "https://api.tiendanube.com/v1/";
const APP_NAME = "App Ferrenet (https://www.soplo.com.ar)";
const APP_ID = 1050;
const APP_SECRET = 'Wn0D5Oj9Vm0cHV5BiBDgYaRiQh2bwAGuTnAbsaPYMXammE5Y';

const CRT_FILE = '/COMODORSACertificationAuthority.crt'; //Ubicacion del certificado SSL
const SSL = false; //Activa o desactiva el SSL
const HEADERS = true; //Devuelvo o no los headers

class apiTN
{
    public $client_id;
    public $client_secret;
    public $user_agent;
    public $app_id;
    public $api_url;
    private $app_secret;

    public function __construct($id, $secret)
    {
        $this->client_id = $id;
        $this->client_secret = $secret;
        $this->user_agent = APP_NAME;
        $this->app_id = APP_ID;
        $this->app_secret = APP_SECRET;
        $this->api_url = API_URL;
    }

    //Esta habria que actualizarla.
    public static function registrar($code)
    {
        $url = 'https://www.tiendanube.com/apps/authorize/token';

        $params = array(
            'client_id' => urlencode(APP_ID),
            'client_secret' => urlencode(APP_SECRET),
            'grant_type' => urlencode('authorization_code'),
            'code' => urlencode($code),
        );

        $params_json = json_encode($params);

        $headers = array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($params_json),
        );

        $options = array(
            CURLOPT_RETURNTRANSFER => true, // return web page
            CURLOPT_HEADER => false, // don't return headers
            CURLINFO_HEADER_OUT => false,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_VERBOSE => true,
            CURLOPT_POSTFIELDS => $params_json,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_FOLLOWLOCATION => true, // follow redirects
            CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_CAINFO => getcwd() . CRT_FILE,
            CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
            CURLOPT_TIMEOUT => 120, // time-out on response
        );

        return self::validate(self::curl($url, $options));
    }

    //Tienda
    public function get_store($params)
    {
        return self::validate($this->get($params, "/store"));
    }
    //Pedidos
    public function get_orders($params)
    {
        return self::validate($this->get($params, "/orders"));
    }

    public function get_order($id, $params)
    {
        return self::validate($this->get($params, "/orders", $id));

    }

    public function put_order($id, $params)
    {
        return self::validate($this->put($params, "/orders", $id));
    }

    public function pack_order($id)
    {
        $params = array();
        return self::validate($this->post($params, "/orders" . "/" . $id . "/pack"), true);
    }

    public function fulfill_order($id)
    {
        $params = array();
        return self::validate($this->post($params, "/orders" . "/" . $id . "/fulfill"));
    }

    //Productos
    public function get_products($params)
    {
        return self::validate($this->get($params, "/products"));
    }

    public function add_product($params)
    {
        return self::validate($this->post($params, "/products"));
    }

    public function modify_product($id, $params)
    {
        return self::validate($this->put($params, "/products", $id));
    }

    public function get_variant($id, $prod_id, $params)
    {
        $action = "/products" . "/" . $prod_id . "/variants" . "/" . $id;
        return self::validate($this->get($params, $action));
    }

    public function put_variant($id, $prod_id, $params, $handle = false)
    {
        $action = "/products" . "/" . $prod_id . "/variants" . "/" . $id;
        if (!$handle) {
            return self::validate($this->put($params, $action));
        } else {
            return $this->put($params, $action, -1, true);
        }
    }

    //Webhooks
    public static function verify_webhook($data, $hmac_header)
    {
        return $hmac_header == hash_hmac('sha256', $data, APP_SECRET);
    }

    public function get_webhooks($params = array())
    {
        return self::validate($this->get($params, "/webhooks"));
    }

    public function add_webhook($event, $url)
    {
        $params = array(
            'event' => $event,
            'url' => $url,
        );

        return self::validate($this->post($params, "/webhooks"));
    }

    public function delete_webhook($id)
    {
        return self::validate($this->delete($id, "/webhooks"));
    }

    //No se usa!
    public static function trim($str)
    {
        return preg_replace(
            "/(\t|\n|\v|\f|\r| |\xC2\x85|\xc2\xa0|\xe1\xa0\x8e|\xe2\x80[\x80-\x8D]|\xe2\x80\xa8|\xe2\x80\xa9|\xe2\x80\xaF|\xe2\x81\x9f|\xe2\x81\xa0|\xe3\x80\x80|\xef\xbb\xbf)+/",
            "",
            $str
        );
    }

    //REQUESTS

    public function get($params, $action, $id = -1)
    {
        $headers = array(
            'Content-Type: application/json',
            sprintf('Authentication: bearer %s', $this->client_secret),
        );

        if ($id == -1) {
            if (empty($params)) {
                $url = API_URL . $this->client_id . $action . "/";
            } else {
                $url = API_URL . $this->client_id . $action . "/" . '?' . http_build_query($params);
            }
        } else {
            if (empty($params)) {
                $url = API_URL . $this->client_id . $action . "/" . strval($id);
            } else {
                $url = API_URL . $this->client_id . $action . "/" . strval($id) . '?' . http_build_query($params);
            }
        }

        $options = array(
            CURLOPT_RETURNTRANSFER => true, // return web page
            CURLOPT_HEADER => false, // don't return headers
            CURLINFO_HEADER_OUT => false,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_FOLLOWLOCATION => true, // follow redirects
            CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
            CURLOPT_USERAGENT => $this->user_agent, // name of client
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_CAINFO => getcwd() . CRT_FILE,
            CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
            CURLOPT_TIMEOUT => 120, // time-out on response
        );

        $response = self::curl($url, $options);
        return $response;

    }

    public function post($params, $action)
    {
        $params_json = json_encode($params);

        $headers = array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($params_json),
            sprintf('Authentication: bearer %s', $this->client_secret),
        );

        $url = API_URL . $this->client_id . $action;

        $options = array(
            CURLOPT_RETURNTRANSFER => true, // return web page
            CURLOPT_HEADER => false, // don't return headers
            CURLINFO_HEADER_OUT => false,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_VERBOSE => true,
            CURLOPT_POSTFIELDS => $params_json,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_FOLLOWLOCATION => true, // follow redirects
            CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
            CURLOPT_USERAGENT => $this->user_agent, // name of client
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_CAINFO => getcwd() . CRT_FILE,
            CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
            CURLOPT_TIMEOUT => 120, // time-out on response
        );

        return self::curl($url, $options);

    }

    public function put($params, $action, $id = -1, $options_only = false)
    {
        $params_json = json_encode($params);

        $headers = array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($params_json),
            sprintf('Authentication: bearer %s', $this->client_secret),
        );

        if ($id == -1) {
            $url = API_URL . $this->client_id . $action;
        } else {
            $url = API_URL . $this->client_id . $action . "/" . strval($id);
        }

        $options = array(
            CURLOPT_RETURNTRANSFER => true, // return web page
            CURLOPT_HEADER => false, // don't return headers
            CURLINFO_HEADER_OUT => false,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_VERBOSE => true,
            CURLOPT_POSTFIELDS => $params_json,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_FOLLOWLOCATION => true, // follow redirects
            CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
            CURLOPT_USERAGENT => $this->user_agent, // name of client
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_CAINFO => getcwd() . CRT_FILE,
            CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
            CURLOPT_TIMEOUT => 120, // time-out on response
        );

        if (!$options_only) {
            return self::curl($url, $options);
        } else {
            return $options;
        }
    }

    public function delete($id, $action)
    {
        $params = array();
        $params_json = json_encode($params);

        $headers = array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($params_json),
            sprintf('Authentication: bearer %s', $this->client_secret),
        );

        $url = API_URL . $this->client_id . $action . "/" . strval($id);

        $options = array(
            CURLOPT_RETURNTRANSFER => true, // return web page
            CURLOPT_HEADER => false, // don't return headers
            CURLINFO_HEADER_OUT => false,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_VERBOSE => true,
            CURLOPT_POSTFIELDS => $params_json,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_FOLLOWLOCATION => true, // follow redirects
            CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
            CURLOPT_USERAGENT => $this->user_agent, // name of client
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_CAINFO => getcwd() . CRT_FILE,
            CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
            CURLOPT_TIMEOUT => 120, // time-out on response
        );

        return self::curl($url, $options);
    }

    public static function curl($url, $options)
    {
        try {

            //Variable para desactivar el SSL para pruebas locales.
            if (!SSL) {
                $options[CURLOPT_SSL_VERIFYPEER] = false;
                $options[CURLOPT_SSL_VERIFYHOST] = 0;
            }

            if (HEADERS) {
                $options[CURLOPT_RETURNTRANSFER] = true;
                $options[CURLOPT_HEADER] = 1;
            }

            $ch = curl_init($url);
            curl_setopt_array($ch, $options);

            $response = curl_exec($ch);

            if ($errno = curl_errno($ch)) {
                $error_message = curl_strerror($errno);
                error_log("cURL error ({$errno}):\n {$error_message}");
            }

            if (HEADERS) {
                $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
                $headers = substr($response, 0, $header_size);
                $body = substr($response, $header_size);

                $out = array();
                array_push($out, self::obtenerHeader('X-Total-Count', $headers));
                array_push($out, self::obtenerHeader('X-Rate-Limit-Limit', $headers));
                array_push($out, self::obtenerHeader('X-Rate-Limit-Remaining', $headers));

                $result = array(
                    'body' => $body,
                    'headers' => array_values($out),
                );
            } else {
                $result = $response;
            }

            curl_close($ch);
            return $result;

        } catch (Exception $e) {
            throw $e;
        }
    }

    //Auxiliares

    public static function obtenerHeader($nombre, $string)
    {
        //Obtengo el indice del inicio del nombre del header.
        $pos_nombre = strpos($string, $nombre);
        if (!$pos_nombre) {
            return false;
        }
        $long_nombre = strlen($nombre);

        //Calculo la posicion inicial del header
        //Le sumo dos por el ':' y el espacio.
        $inicio_val = $pos_nombre + $long_nombre + 2;

        $str_aux = substr($string, $inicio_val);

        $val = preg_split('#\s+#', $str_aux)[0];

        $out = array(
            'header' => $nombre,
            'valor' => $val,
        );

        return $out;

    }

    public static function validate($result, $show404 = false)
    {
        if (HEADERS) {
            $headers = $result['headers'];

            // $headers = json_encode($result['headers']);
            $result = $result['body'];
        }

        $out = json_decode($result, true);
        if (is_null($out)) {
            error_log("Error al decodificar el JSON.");
            // throw new Exception();
            return false;
        }

        if (isset($out['code'])) {
            $code = intval($out['code'], 10);
            if ($code >= 400 && $code < 500) {
                if ($code == 404 && !show404) {
                    $out = array();
                } else {
                    error_log("API TN - Client Error: " . $code);
                    return false;
                }
            }
            if ($code >= 500) {
                error_log("API TN - Server Error: " . $code);
                return false;
            }
        }

        if (isset($headers) && HEADERS) {
            $out['headers'] = $headers;
        }

        return $out;
    }

}
