var app = {
    //PROPIEDADES, GETTERS Y SETTERS
    tamano_pagina: 100,
    _cant_total: 0,
    get cant_total() {
        return this._cant_total;
    },
    set cant_total(val) {
        $('.cant_total').text(val);
        this._cant_total = val;
    },
    _cant_total_tn: 0,
    get cant_total_tn() {
        return this._cant_total_tn;
    },
    set cant_total_tn(val) {
        $('.cant_total_tn').text(val);
        this._cant_total_tn = val;
    },
    _cant_sincronizados: 0,
    get cant_sincronizados() {
        return this._cant_sincronizados;
    },
    set cant_sincronizados(val) {
        $('.cant_sincronizados').text(val);
        this._cant_sincronizados = val;
    },
    _cant_actualizados: 0,
    get cant_actualizados() {
        return this._cant_actualizados;
    },
    set cant_actualizados(val) {
        if (val < 0) {
            this._cant_actualizados = 0;
        } else {
            this._cant_actualizados = this._cant_actualizados + val;
        }
        $('.cant_actualizados').text(this._cant_actualizados.toString());
    },
    _consultas_pendientes: 0,
    get consultas_pendientes() {
        return this._consultas_pendientes;
    },
    set consultas_pendientes(val) {
        if (val == false) {
            this._consultas_pendientes = 0;
        } else {
            this._consultas_pendientes = this._consultas_pendientes + val;
        }
        $('.consultas_pendientes').text(this._consultas_pendientes.toString());
    },
    _cant_enviados: 0,
    get cant_enviados() {
        return this._cant_enviados;
    },
    set cant_enviados(val) {
        if (val == false) {
            this._cant_enviados = 0;
        } else {
            this._cant_enviados = this._cant_enviados + val;
        }
        $('.cant_enviados').text(this._cant_enviados.toString());
    },
    _cant_errores: 0,
    get cant_errores() {
        return this._cant_errores;
    },
    set cant_errores(val) {
        if (val < 0) {
            this._cant_errores = 0;
        } else {
            this._cant_errores = this._cant_errores + val;
        }
        $('.cant_errores').text(this._cant_errores);
    },
    _cant_omitidos: 0,
    get cant_omitidos() {
        return this._cant_omitidos;
    },
    set cant_omitidos(val) {
        if (val < 0) {
            this._cant_omitidos = 0;
        } else {
            this._cant_omitidos = this._cant_omitidos + val;
        }
        $('.cant_omitidos').text(this._cant_omitidos);
    },
    _errores: [],
    get errores() {
        return this._errores;
    },
    set errores(val) {
        if (val == -1) {
            this._errores = [];
            $('.errores').fadeOut(500);
            $('.lista-errores').html('');
        } else if (val && val != '') {
            $('.errores').fadeIn(500);
            $('.lista-errores').append('<li>' + val + '</li>');
            this._errores.push = val;
        }
    },
    _tiempo_servidor: 0,
    get tiempo_servidor() {
        return Math.round(this._tiempo_servidor * 100) / 100
    },
    set tiempo_servidor(val) {
        if (val < 0) {
            this._tiempo_servidor = 0;
        } else {
            this._tiempo_servidor = this._tiempo_servidor + val;
        }
        $('.tiempo_servidor').text(this.tiempo_servidor);
    },
    _trabajando: false,
    get trabajando() {
        return this._trabajando;
    },
    set trabajando(val) {
        if (!val) {
            this._trabajando = false;
            $('.loader').fadeOut(500);
        } else {
            this.detener = false;
            this._trabajando = true;
            this._ult_trabajo = Date.now();
            $('.loader').fadeIn(500);
        }
    },
    _ult_trabajo: Date.now(),
    get ult_trabajo() {
        return this._ult_trabajo;
    },
    get cant_paginas() {
        return Math.ceil(this._cant_total / this.tamano_pagina);
    },
    get porcentajeAvance() {
        return (this._cant_actualizados + this._cant_errores + this._cant_omitidos) / this._cant_total;
    },
    detener: false,

    _limite_consultas: 0,
    get limite_consultas() {
        return this._limite_consultas;
    },
    set limite_consultas(val) {
        this._limite_consultas = val;
        $('.limite_consultas').text(this._limite_consultas);
    },
    _consultas_restantes: 0,
    get consultas_restantes() {
        return this._consultas_restantes;
    },
    set consultas_restantes(val) {
        this._consultas_restantes = val;
        $('.consultas_restantes').text(this._consultas_restantes);
    },
    //Funciones Auxiliares
    resetearContadores: function () {
        this.errores = -1;
        this.cant_actualizados = -1;
        this.consultas_pendientes = false;
        this.cant_errores = -1;
        this.cant_omitidos = -1;
        this.tiempo_servidor = 0;
    },

    detenerTrabajo: function (mensaje) {
        if (mensaje)
            console.log(mensaje);
        this.detener = true;
        this.trabajando = false;
    },

    error: function (err) {
        console.log(err);
    },

    ajaxAsync: async function (ajaxurl, args) {

        try {
            const result = await $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: args
            });

            //Mas validacion aca!!

            if (result.headers) {
                this.cargarHeaders(result.headers);
            }

            return result;
        } catch (error) {
            this.error(error);
        }
    },


    asyncFor: async function (length, callback) {
        for (let index = 1; index < length; index++) {
            if (this.detener == true) {
                this.detener = false;
                break;
            }
            await callback(index);
        }
    },

    asyncWhile: async function (condicion, callback) {
        while (condicion) {
            if (this.detener == true) {
                this.detener = false;
                break;
            }
            await callback();
        }
    },

    esperar: ms => new Promise((r, j) => setTimeout(r, ms)),

    obtenerTotalTransaccion: function (data) {
        var total_tn = data.headers.filter(valor => {
            return valor.header == 'X-Total-Count';
        })[0];

        if (total_tn) {
            return parseInt(total_tn.valor, 10);
        }
        return false;
    },

    cargarHeaders: function (headers) {

        var limite = headers.filter(valor => {
            return valor.header == 'X-Rate-Limit-Limit';
        })[0];

        if (limite) {
            this.limite_consultas = parseInt(limite.valor, 10);
        }

        var restantes = headers.filter(valor => {
            return valor.header == 'X-Rate-Limit-Remaining';
        })[0];

        if (restantes) {
            this.consultas_restantes = parseInt(restantes.valor, 10);
        }
    },

    isFunction: function (functionToCheck) {
        return functionToCheck && {}.toString.call(functionToCheck) === '[object Function]';
    },


    //Controladores
    sincronizarProductos: async function () {
        if (this.trabajando == true)
            return;

        this.resetearContadores()
        this.trabajando = true;
        const ts = Date.now();

        await this.contarProductos(false);
        let that = this;
        await this.asyncFor(that.cant_paginas, async function (i) {

            let data = await that.ajaxAsync('controllers/sincronizarProductos.php', {
                pagina: i
            });

            try {

                that.cant_actualizados = data.cant_actualizados;
                that.cant_errores = data.cant_errores;
                that.cant_omitidos = data.cant_omitidos;
                that.tiempo_servidor = data.duracion;

                if (data.errores.length > 0) {
                    data.errores.forEach(element => {
                        that.errores = element;
                    });
                }

                if (data.seguir == false) {
                    that.detenerTrabajo('detenido por el servidor al sincronizar productos');
                }

                return true;

            } catch (error) {
                that.error(error);
                return false;
            }
        });
        this.contarProductos(true);
    },

    actualizarStockProductos: function (indice, cantidad, callbackSuccess = false, callbackError = false) {
        var that = this;
        var args = {
            indice: indice,
            cantidad: cantidad,
        };

        const manejadorSuccess = function (data, textStatus, jqXHR) {
            console.log('success', indice, data);
            that.cargarHeaders(data.headers);

            that.cant_actualizados = data.cant_actualizados;
            that.cant_errores = data.cant_errores;
            that.cant_omitidos = data.cant_omitidos;
            that.tiempo_servidor = data.duracion;
            that.seguir = data.seguir;
            that.consultas_pendientes = cantidad * -1;

            if (data.errores.length > 0) {
                data.errores.forEach(element => {
                    that.errores = element;
                });
            }

            if (data.seguir == false) {
                that.detenerTrabajo('detenido por el servidor al finalizar actualizacion de Stock');
            }

            if (that.isFunction(callbackSuccess)) {
                callbackSuccess(data, textStatus, jqXHR);
            }
        };

        const manejadorComplete = function (jqXHR, textStatus, errorThrown) {};

        const manejadorError = function (jqXHR, textStatus, errorThrown) {
            console.log(jqXHR, textStatus, errorThrown);
            that.consultas_pendientes = cantidad * -1;

            if (that.isFunction(callbackError)) {
                callbackError(jqXHR, textStatus, errorThrown);
            }
        };

        var settings = {
            url: 'controllers/actualizarStock.php',
            type: 'POST',
            data: args,
            success: manejadorSuccess,
            error: manejadorError,
            complete: manejadorComplete
        };

        $.ajax(settings);
    },

    actualizarStock: async function () {
        if (this.trabajando == true)
            return;

        const buffer = 20;
        var that = this;
        await this.contarProductos(false);

        this.resetearContadores()
        this.trabajando = true;

        //Indice de inicio
        var i = 0;
        //Numero de productos a procesar
        var n = 2;
        this.seguir = true;
        await this.asyncWhile(this.seguir, async function () {
            if (that.consultas_restantes >= that.consultas_pendientes + buffer) {
                i = i + n;
                that.consultas_pendientes = n;
                if (that.consultas_pendientes < 0) {
                    debugger;
                }
                that.cant_enviados = n;
                that.actualizarStockProductos(i, n, false, false);
                await that.esperar(1500);
            } else {
                await that.esperar(1000);
                that.cant_enviados = n;
                that.actualizarStockProductos(i, n, false, false);
            }
        });

        this.detenerTrabajo('Detenido al finalizar actualizacion de Stock');
    },



    contarProductos: async function (detener = true) {
        if (this.trabajando == true)
            return;

        this.trabajando = true;
        const ts = Date.now();

        try {
            const data = await this.ajaxAsync('controllers/contarProductos.php', {});
            this.cant_total = data.cant_total;
            this.cant_sincronizados = data.cant_sincronizados;

            this.cant_total_tn = this.obtenerTotalTransaccion(data);
            if (ts >= this.ult_trabajo && detener) {
                this.detenerTrabajo('detenido al finalizar de contar productos');
            }
            return data;
        } catch (error) {
            // this.trabajando = false;
            this.error(error);
        }
    },
}