
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- tienda_tn
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `tienda_tn`;

CREATE TABLE `tienda_tn`
(
    `tienda_id` INTEGER NOT NULL,
    `nombre` VARCHAR(255) NOT NULL,
    `access_token` VARCHAR(40) NOT NULL,
    `ts_productos` DATETIME,
    `ts_stock` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`tienda_id`)
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- tiendanube
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `tiendanube`;

CREATE TABLE `tiendanube`
(
    `producto_id` INTEGER NOT NULL AUTO_INCREMENT,
    `sku` VARCHAR(32) NOT NULL,
    `stock` FLOAT NOT NULL,
    `poriginal` FLOAT NOT NULL,
    `ppromocion` FLOAT NOT NULL,
    `product_id` INTEGER,
    `variant_id` INTEGER,
    `tienda_id` INTEGER NOT NULL,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`producto_id`),
    INDEX `tiendanube_fi_1f89f9` (`tienda_id`),
    CONSTRAINT `tiendanube_fk_1f89f9`
        FOREIGN KEY (`tienda_id`)
        REFERENCES `tienda_tn` (`tienda_id`)
) ENGINE=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
