<?php

namespace Map;

use \Producto;
use \ProductoQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'tiendanube' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class ProductoTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = '.Map.ProductoTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'suitecms';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'tiendanube';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Producto';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Producto';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 10;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 10;

    /**
     * the column name for the producto_id field
     */
    const COL_PRODUCTO_ID = 'tiendanube.producto_id';

    /**
     * the column name for the sku field
     */
    const COL_SKU = 'tiendanube.sku';

    /**
     * the column name for the stock field
     */
    const COL_STOCK = 'tiendanube.stock';

    /**
     * the column name for the poriginal field
     */
    const COL_PORIGINAL = 'tiendanube.poriginal';

    /**
     * the column name for the ppromocion field
     */
    const COL_PPROMOCION = 'tiendanube.ppromocion';

    /**
     * the column name for the product_id field
     */
    const COL_PRODUCT_ID = 'tiendanube.product_id';

    /**
     * the column name for the variant_id field
     */
    const COL_VARIANT_ID = 'tiendanube.variant_id';

    /**
     * the column name for the tienda_id field
     */
    const COL_TIENDA_ID = 'tiendanube.tienda_id';

    /**
     * the column name for the created_at field
     */
    const COL_CREATED_AT = 'tiendanube.created_at';

    /**
     * the column name for the updated_at field
     */
    const COL_UPDATED_AT = 'tiendanube.updated_at';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('ProductoId', 'Sku', 'Stock', 'Poriginal', 'Ppromocion', 'ProductId', 'VariantId', 'TiendaId', 'CreatedAt', 'UpdatedAt', ),
        self::TYPE_CAMELNAME     => array('productoId', 'sku', 'stock', 'poriginal', 'ppromocion', 'productId', 'variantId', 'tiendaId', 'createdAt', 'updatedAt', ),
        self::TYPE_COLNAME       => array(ProductoTableMap::COL_PRODUCTO_ID, ProductoTableMap::COL_SKU, ProductoTableMap::COL_STOCK, ProductoTableMap::COL_PORIGINAL, ProductoTableMap::COL_PPROMOCION, ProductoTableMap::COL_PRODUCT_ID, ProductoTableMap::COL_VARIANT_ID, ProductoTableMap::COL_TIENDA_ID, ProductoTableMap::COL_CREATED_AT, ProductoTableMap::COL_UPDATED_AT, ),
        self::TYPE_FIELDNAME     => array('producto_id', 'sku', 'stock', 'poriginal', 'ppromocion', 'product_id', 'variant_id', 'tienda_id', 'created_at', 'updated_at', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('ProductoId' => 0, 'Sku' => 1, 'Stock' => 2, 'Poriginal' => 3, 'Ppromocion' => 4, 'ProductId' => 5, 'VariantId' => 6, 'TiendaId' => 7, 'CreatedAt' => 8, 'UpdatedAt' => 9, ),
        self::TYPE_CAMELNAME     => array('productoId' => 0, 'sku' => 1, 'stock' => 2, 'poriginal' => 3, 'ppromocion' => 4, 'productId' => 5, 'variantId' => 6, 'tiendaId' => 7, 'createdAt' => 8, 'updatedAt' => 9, ),
        self::TYPE_COLNAME       => array(ProductoTableMap::COL_PRODUCTO_ID => 0, ProductoTableMap::COL_SKU => 1, ProductoTableMap::COL_STOCK => 2, ProductoTableMap::COL_PORIGINAL => 3, ProductoTableMap::COL_PPROMOCION => 4, ProductoTableMap::COL_PRODUCT_ID => 5, ProductoTableMap::COL_VARIANT_ID => 6, ProductoTableMap::COL_TIENDA_ID => 7, ProductoTableMap::COL_CREATED_AT => 8, ProductoTableMap::COL_UPDATED_AT => 9, ),
        self::TYPE_FIELDNAME     => array('producto_id' => 0, 'sku' => 1, 'stock' => 2, 'poriginal' => 3, 'ppromocion' => 4, 'product_id' => 5, 'variant_id' => 6, 'tienda_id' => 7, 'created_at' => 8, 'updated_at' => 9, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('tiendanube');
        $this->setPhpName('Producto');
        $this->setIdentifierQuoting(false);
        $this->setClassName('\\Producto');
        $this->setPackage('');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('producto_id', 'ProductoId', 'INTEGER', true, null, null);
        $this->addColumn('sku', 'Sku', 'VARCHAR', true, 32, null);
        $this->addColumn('stock', 'Stock', 'FLOAT', true, null, null);
        $this->addColumn('poriginal', 'Poriginal', 'FLOAT', true, null, null);
        $this->addColumn('ppromocion', 'Ppromocion', 'FLOAT', true, null, null);
        $this->addColumn('product_id', 'ProductId', 'INTEGER', false, null, null);
        $this->addColumn('variant_id', 'VariantId', 'INTEGER', false, null, null);
        $this->addForeignKey('tienda_id', 'TiendaId', 'INTEGER', 'tienda_tn', 'tienda_id', true, null, null);
        $this->addColumn('created_at', 'CreatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('updated_at', 'UpdatedAt', 'TIMESTAMP', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Tienda', '\\Tienda', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':tienda_id',
    1 => ':tienda_id',
  ),
), null, null, null, false);
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'timestampable' => array('create_column' => 'created_at', 'update_column' => 'updated_at', 'disable_created_at' => 'false', 'disable_updated_at' => 'false', ),
        );
    } // getBehaviors()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('ProductoId', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? ProductoTableMap::CLASS_DEFAULT : ProductoTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Producto object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = ProductoTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ProductoTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ProductoTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ProductoTableMap::OM_CLASS;
            /** @var Producto $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ProductoTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ProductoTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ProductoTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Producto $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ProductoTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ProductoTableMap::COL_PRODUCTO_ID);
            $criteria->addSelectColumn(ProductoTableMap::COL_SKU);
            $criteria->addSelectColumn(ProductoTableMap::COL_STOCK);
            $criteria->addSelectColumn(ProductoTableMap::COL_PORIGINAL);
            $criteria->addSelectColumn(ProductoTableMap::COL_PPROMOCION);
            $criteria->addSelectColumn(ProductoTableMap::COL_PRODUCT_ID);
            $criteria->addSelectColumn(ProductoTableMap::COL_VARIANT_ID);
            $criteria->addSelectColumn(ProductoTableMap::COL_TIENDA_ID);
            $criteria->addSelectColumn(ProductoTableMap::COL_CREATED_AT);
            $criteria->addSelectColumn(ProductoTableMap::COL_UPDATED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.producto_id');
            $criteria->addSelectColumn($alias . '.sku');
            $criteria->addSelectColumn($alias . '.stock');
            $criteria->addSelectColumn($alias . '.poriginal');
            $criteria->addSelectColumn($alias . '.ppromocion');
            $criteria->addSelectColumn($alias . '.product_id');
            $criteria->addSelectColumn($alias . '.variant_id');
            $criteria->addSelectColumn($alias . '.tienda_id');
            $criteria->addSelectColumn($alias . '.created_at');
            $criteria->addSelectColumn($alias . '.updated_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(ProductoTableMap::DATABASE_NAME)->getTable(ProductoTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(ProductoTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(ProductoTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new ProductoTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Producto or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Producto object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductoTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Producto) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ProductoTableMap::DATABASE_NAME);
            $criteria->add(ProductoTableMap::COL_PRODUCTO_ID, (array) $values, Criteria::IN);
        }

        $query = ProductoQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ProductoTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ProductoTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the tiendanube table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return ProductoQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Producto or Criteria object.
     *
     * @param mixed               $criteria Criteria or Producto object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductoTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Producto object
        }

        if ($criteria->containsKey(ProductoTableMap::COL_PRODUCTO_ID) && $criteria->keyContainsValue(ProductoTableMap::COL_PRODUCTO_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ProductoTableMap::COL_PRODUCTO_ID.')');
        }


        // Set the correct dbName
        $query = ProductoQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // ProductoTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
ProductoTableMap::buildTableMap();
