<?php

namespace Base;

use \Tienda as ChildTienda;
use \TiendaQuery as ChildTiendaQuery;
use \Exception;
use \PDO;
use Map\TiendaTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'tienda_tn' table.
 *
 *
 *
 * @method     ChildTiendaQuery orderByTiendaId($order = Criteria::ASC) Order by the tienda_id column
 * @method     ChildTiendaQuery orderByNombre($order = Criteria::ASC) Order by the nombre column
 * @method     ChildTiendaQuery orderByAccessToken($order = Criteria::ASC) Order by the access_token column
 * @method     ChildTiendaQuery orderByTSProductos($order = Criteria::ASC) Order by the ts_productos column
 * @method     ChildTiendaQuery orderByTSStock($order = Criteria::ASC) Order by the ts_stock column
 * @method     ChildTiendaQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildTiendaQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 *
 * @method     ChildTiendaQuery groupByTiendaId() Group by the tienda_id column
 * @method     ChildTiendaQuery groupByNombre() Group by the nombre column
 * @method     ChildTiendaQuery groupByAccessToken() Group by the access_token column
 * @method     ChildTiendaQuery groupByTSProductos() Group by the ts_productos column
 * @method     ChildTiendaQuery groupByTSStock() Group by the ts_stock column
 * @method     ChildTiendaQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildTiendaQuery groupByUpdatedAt() Group by the updated_at column
 *
 * @method     ChildTiendaQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildTiendaQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildTiendaQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildTiendaQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildTiendaQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildTiendaQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildTiendaQuery leftJoinTienda($relationAlias = null) Adds a LEFT JOIN clause to the query using the Tienda relation
 * @method     ChildTiendaQuery rightJoinTienda($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Tienda relation
 * @method     ChildTiendaQuery innerJoinTienda($relationAlias = null) Adds a INNER JOIN clause to the query using the Tienda relation
 *
 * @method     ChildTiendaQuery joinWithTienda($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Tienda relation
 *
 * @method     ChildTiendaQuery leftJoinWithTienda() Adds a LEFT JOIN clause and with to the query using the Tienda relation
 * @method     ChildTiendaQuery rightJoinWithTienda() Adds a RIGHT JOIN clause and with to the query using the Tienda relation
 * @method     ChildTiendaQuery innerJoinWithTienda() Adds a INNER JOIN clause and with to the query using the Tienda relation
 *
 * @method     \ProductoQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildTienda findOne(ConnectionInterface $con = null) Return the first ChildTienda matching the query
 * @method     ChildTienda findOneOrCreate(ConnectionInterface $con = null) Return the first ChildTienda matching the query, or a new ChildTienda object populated from the query conditions when no match is found
 *
 * @method     ChildTienda findOneByTiendaId(int $tienda_id) Return the first ChildTienda filtered by the tienda_id column
 * @method     ChildTienda findOneByNombre(string $nombre) Return the first ChildTienda filtered by the nombre column
 * @method     ChildTienda findOneByAccessToken(string $access_token) Return the first ChildTienda filtered by the access_token column
 * @method     ChildTienda findOneByTSProductos(string $ts_productos) Return the first ChildTienda filtered by the ts_productos column
 * @method     ChildTienda findOneByTSStock(string $ts_stock) Return the first ChildTienda filtered by the ts_stock column
 * @method     ChildTienda findOneByCreatedAt(string $created_at) Return the first ChildTienda filtered by the created_at column
 * @method     ChildTienda findOneByUpdatedAt(string $updated_at) Return the first ChildTienda filtered by the updated_at column *

 * @method     ChildTienda requirePk($key, ConnectionInterface $con = null) Return the ChildTienda by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOne(ConnectionInterface $con = null) Return the first ChildTienda matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildTienda requireOneByTiendaId(int $tienda_id) Return the first ChildTienda filtered by the tienda_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOneByNombre(string $nombre) Return the first ChildTienda filtered by the nombre column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOneByAccessToken(string $access_token) Return the first ChildTienda filtered by the access_token column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOneByTSProductos(string $ts_productos) Return the first ChildTienda filtered by the ts_productos column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOneByTSStock(string $ts_stock) Return the first ChildTienda filtered by the ts_stock column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOneByCreatedAt(string $created_at) Return the first ChildTienda filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTienda requireOneByUpdatedAt(string $updated_at) Return the first ChildTienda filtered by the updated_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildTienda[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildTienda objects based on current ModelCriteria
 * @method     ChildTienda[]|ObjectCollection findByTiendaId(int $tienda_id) Return ChildTienda objects filtered by the tienda_id column
 * @method     ChildTienda[]|ObjectCollection findByNombre(string $nombre) Return ChildTienda objects filtered by the nombre column
 * @method     ChildTienda[]|ObjectCollection findByAccessToken(string $access_token) Return ChildTienda objects filtered by the access_token column
 * @method     ChildTienda[]|ObjectCollection findByTSProductos(string $ts_productos) Return ChildTienda objects filtered by the ts_productos column
 * @method     ChildTienda[]|ObjectCollection findByTSStock(string $ts_stock) Return ChildTienda objects filtered by the ts_stock column
 * @method     ChildTienda[]|ObjectCollection findByCreatedAt(string $created_at) Return ChildTienda objects filtered by the created_at column
 * @method     ChildTienda[]|ObjectCollection findByUpdatedAt(string $updated_at) Return ChildTienda objects filtered by the updated_at column
 * @method     ChildTienda[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class TiendaQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Base\TiendaQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'suitecms', $modelName = '\\Tienda', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildTiendaQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildTiendaQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildTiendaQuery) {
            return $criteria;
        }
        $query = new ChildTiendaQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildTienda|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(TiendaTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = TiendaTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildTienda A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT tienda_id, nombre, access_token, ts_productos, ts_stock, created_at, updated_at FROM tienda_tn WHERE tienda_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildTienda $obj */
            $obj = new ChildTienda();
            $obj->hydrate($row);
            TiendaTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildTienda|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the tienda_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTiendaId(1234); // WHERE tienda_id = 1234
     * $query->filterByTiendaId(array(12, 34)); // WHERE tienda_id IN (12, 34)
     * $query->filterByTiendaId(array('min' => 12)); // WHERE tienda_id > 12
     * </code>
     *
     * @param     mixed $tiendaId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByTiendaId($tiendaId = null, $comparison = null)
    {
        if (is_array($tiendaId)) {
            $useMinMax = false;
            if (isset($tiendaId['min'])) {
                $this->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $tiendaId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($tiendaId['max'])) {
                $this->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $tiendaId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $tiendaId, $comparison);
    }

    /**
     * Filter the query on the nombre column
     *
     * Example usage:
     * <code>
     * $query->filterByNombre('fooValue');   // WHERE nombre = 'fooValue'
     * $query->filterByNombre('%fooValue%', Criteria::LIKE); // WHERE nombre LIKE '%fooValue%'
     * </code>
     *
     * @param     string $nombre The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByNombre($nombre = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($nombre)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_NOMBRE, $nombre, $comparison);
    }

    /**
     * Filter the query on the access_token column
     *
     * Example usage:
     * <code>
     * $query->filterByAccessToken('fooValue');   // WHERE access_token = 'fooValue'
     * $query->filterByAccessToken('%fooValue%', Criteria::LIKE); // WHERE access_token LIKE '%fooValue%'
     * </code>
     *
     * @param     string $accessToken The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByAccessToken($accessToken = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($accessToken)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_ACCESS_TOKEN, $accessToken, $comparison);
    }

    /**
     * Filter the query on the ts_productos column
     *
     * Example usage:
     * <code>
     * $query->filterByTSProductos('2011-03-14'); // WHERE ts_productos = '2011-03-14'
     * $query->filterByTSProductos('now'); // WHERE ts_productos = '2011-03-14'
     * $query->filterByTSProductos(array('max' => 'yesterday')); // WHERE ts_productos > '2011-03-13'
     * </code>
     *
     * @param     mixed $tSProductos The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByTSProductos($tSProductos = null, $comparison = null)
    {
        if (is_array($tSProductos)) {
            $useMinMax = false;
            if (isset($tSProductos['min'])) {
                $this->addUsingAlias(TiendaTableMap::COL_TS_PRODUCTOS, $tSProductos['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($tSProductos['max'])) {
                $this->addUsingAlias(TiendaTableMap::COL_TS_PRODUCTOS, $tSProductos['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_TS_PRODUCTOS, $tSProductos, $comparison);
    }

    /**
     * Filter the query on the ts_stock column
     *
     * Example usage:
     * <code>
     * $query->filterByTSStock('2011-03-14'); // WHERE ts_stock = '2011-03-14'
     * $query->filterByTSStock('now'); // WHERE ts_stock = '2011-03-14'
     * $query->filterByTSStock(array('max' => 'yesterday')); // WHERE ts_stock > '2011-03-13'
     * </code>
     *
     * @param     mixed $tSStock The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByTSStock($tSStock = null, $comparison = null)
    {
        if (is_array($tSStock)) {
            $useMinMax = false;
            if (isset($tSStock['min'])) {
                $this->addUsingAlias(TiendaTableMap::COL_TS_STOCK, $tSStock['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($tSStock['max'])) {
                $this->addUsingAlias(TiendaTableMap::COL_TS_STOCK, $tSStock['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_TS_STOCK, $tSStock, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(TiendaTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(TiendaTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(TiendaTableMap::COL_UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(TiendaTableMap::COL_UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TiendaTableMap::COL_UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query by a related \Producto object
     *
     * @param \Producto|ObjectCollection $producto the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildTiendaQuery The current query, for fluid interface
     */
    public function filterByTienda($producto, $comparison = null)
    {
        if ($producto instanceof \Producto) {
            return $this
                ->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $producto->getTiendaId(), $comparison);
        } elseif ($producto instanceof ObjectCollection) {
            return $this
                ->useTiendaQuery()
                ->filterByPrimaryKeys($producto->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByTienda() only accepts arguments of type \Producto or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Tienda relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function joinTienda($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Tienda');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Tienda');
        }

        return $this;
    }

    /**
     * Use the Tienda relation Producto object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \ProductoQuery A secondary query class using the current class as primary query
     */
    public function useTiendaQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinTienda($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Tienda', '\ProductoQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildTienda $tienda Object to remove from the list of results
     *
     * @return $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function prune($tienda = null)
    {
        if ($tienda) {
            $this->addUsingAlias(TiendaTableMap::COL_TIENDA_ID, $tienda->getTiendaId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the tienda_tn table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(TiendaTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            TiendaTableMap::clearInstancePool();
            TiendaTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(TiendaTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(TiendaTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            TiendaTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            TiendaTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(TiendaTableMap::COL_UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(TiendaTableMap::COL_UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(TiendaTableMap::COL_UPDATED_AT);
    }

    /**
     * Order by create date desc
     *
     * @return     $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(TiendaTableMap::COL_CREATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(TiendaTableMap::COL_CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date asc
     *
     * @return     $this|ChildTiendaQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(TiendaTableMap::COL_CREATED_AT);
    }

} // TiendaQuery
