<?php

namespace Base;

use \Producto as ChildProducto;
use \ProductoQuery as ChildProductoQuery;
use \Exception;
use \PDO;
use Map\ProductoTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'tiendanube' table.
 *
 *
 *
 * @method     ChildProductoQuery orderByProductoId($order = Criteria::ASC) Order by the producto_id column
 * @method     ChildProductoQuery orderBySku($order = Criteria::ASC) Order by the sku column
 * @method     ChildProductoQuery orderByStock($order = Criteria::ASC) Order by the stock column
 * @method     ChildProductoQuery orderByPoriginal($order = Criteria::ASC) Order by the poriginal column
 * @method     ChildProductoQuery orderByPpromocion($order = Criteria::ASC) Order by the ppromocion column
 * @method     ChildProductoQuery orderByProductId($order = Criteria::ASC) Order by the product_id column
 * @method     ChildProductoQuery orderByVariantId($order = Criteria::ASC) Order by the variant_id column
 * @method     ChildProductoQuery orderByTiendaId($order = Criteria::ASC) Order by the tienda_id column
 * @method     ChildProductoQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildProductoQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 *
 * @method     ChildProductoQuery groupByProductoId() Group by the producto_id column
 * @method     ChildProductoQuery groupBySku() Group by the sku column
 * @method     ChildProductoQuery groupByStock() Group by the stock column
 * @method     ChildProductoQuery groupByPoriginal() Group by the poriginal column
 * @method     ChildProductoQuery groupByPpromocion() Group by the ppromocion column
 * @method     ChildProductoQuery groupByProductId() Group by the product_id column
 * @method     ChildProductoQuery groupByVariantId() Group by the variant_id column
 * @method     ChildProductoQuery groupByTiendaId() Group by the tienda_id column
 * @method     ChildProductoQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildProductoQuery groupByUpdatedAt() Group by the updated_at column
 *
 * @method     ChildProductoQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildProductoQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildProductoQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildProductoQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildProductoQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildProductoQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildProductoQuery leftJoinTienda($relationAlias = null) Adds a LEFT JOIN clause to the query using the Tienda relation
 * @method     ChildProductoQuery rightJoinTienda($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Tienda relation
 * @method     ChildProductoQuery innerJoinTienda($relationAlias = null) Adds a INNER JOIN clause to the query using the Tienda relation
 *
 * @method     ChildProductoQuery joinWithTienda($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Tienda relation
 *
 * @method     ChildProductoQuery leftJoinWithTienda() Adds a LEFT JOIN clause and with to the query using the Tienda relation
 * @method     ChildProductoQuery rightJoinWithTienda() Adds a RIGHT JOIN clause and with to the query using the Tienda relation
 * @method     ChildProductoQuery innerJoinWithTienda() Adds a INNER JOIN clause and with to the query using the Tienda relation
 *
 * @method     \TiendaQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildProducto findOne(ConnectionInterface $con = null) Return the first ChildProducto matching the query
 * @method     ChildProducto findOneOrCreate(ConnectionInterface $con = null) Return the first ChildProducto matching the query, or a new ChildProducto object populated from the query conditions when no match is found
 *
 * @method     ChildProducto findOneByProductoId(int $producto_id) Return the first ChildProducto filtered by the producto_id column
 * @method     ChildProducto findOneBySku(string $sku) Return the first ChildProducto filtered by the sku column
 * @method     ChildProducto findOneByStock(double $stock) Return the first ChildProducto filtered by the stock column
 * @method     ChildProducto findOneByPoriginal(double $poriginal) Return the first ChildProducto filtered by the poriginal column
 * @method     ChildProducto findOneByPpromocion(double $ppromocion) Return the first ChildProducto filtered by the ppromocion column
 * @method     ChildProducto findOneByProductId(int $product_id) Return the first ChildProducto filtered by the product_id column
 * @method     ChildProducto findOneByVariantId(int $variant_id) Return the first ChildProducto filtered by the variant_id column
 * @method     ChildProducto findOneByTiendaId(int $tienda_id) Return the first ChildProducto filtered by the tienda_id column
 * @method     ChildProducto findOneByCreatedAt(string $created_at) Return the first ChildProducto filtered by the created_at column
 * @method     ChildProducto findOneByUpdatedAt(string $updated_at) Return the first ChildProducto filtered by the updated_at column *

 * @method     ChildProducto requirePk($key, ConnectionInterface $con = null) Return the ChildProducto by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOne(ConnectionInterface $con = null) Return the first ChildProducto matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProducto requireOneByProductoId(int $producto_id) Return the first ChildProducto filtered by the producto_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneBySku(string $sku) Return the first ChildProducto filtered by the sku column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByStock(double $stock) Return the first ChildProducto filtered by the stock column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByPoriginal(double $poriginal) Return the first ChildProducto filtered by the poriginal column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByPpromocion(double $ppromocion) Return the first ChildProducto filtered by the ppromocion column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByProductId(int $product_id) Return the first ChildProducto filtered by the product_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByVariantId(int $variant_id) Return the first ChildProducto filtered by the variant_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByTiendaId(int $tienda_id) Return the first ChildProducto filtered by the tienda_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByCreatedAt(string $created_at) Return the first ChildProducto filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProducto requireOneByUpdatedAt(string $updated_at) Return the first ChildProducto filtered by the updated_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProducto[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildProducto objects based on current ModelCriteria
 * @method     ChildProducto[]|ObjectCollection findByProductoId(int $producto_id) Return ChildProducto objects filtered by the producto_id column
 * @method     ChildProducto[]|ObjectCollection findBySku(string $sku) Return ChildProducto objects filtered by the sku column
 * @method     ChildProducto[]|ObjectCollection findByStock(double $stock) Return ChildProducto objects filtered by the stock column
 * @method     ChildProducto[]|ObjectCollection findByPoriginal(double $poriginal) Return ChildProducto objects filtered by the poriginal column
 * @method     ChildProducto[]|ObjectCollection findByPpromocion(double $ppromocion) Return ChildProducto objects filtered by the ppromocion column
 * @method     ChildProducto[]|ObjectCollection findByProductId(int $product_id) Return ChildProducto objects filtered by the product_id column
 * @method     ChildProducto[]|ObjectCollection findByVariantId(int $variant_id) Return ChildProducto objects filtered by the variant_id column
 * @method     ChildProducto[]|ObjectCollection findByTiendaId(int $tienda_id) Return ChildProducto objects filtered by the tienda_id column
 * @method     ChildProducto[]|ObjectCollection findByCreatedAt(string $created_at) Return ChildProducto objects filtered by the created_at column
 * @method     ChildProducto[]|ObjectCollection findByUpdatedAt(string $updated_at) Return ChildProducto objects filtered by the updated_at column
 * @method     ChildProducto[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ProductoQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Base\ProductoQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'suitecms', $modelName = '\\Producto', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildProductoQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildProductoQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildProductoQuery) {
            return $criteria;
        }
        $query = new ChildProductoQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildProducto|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProductoTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ProductoTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProducto A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT producto_id, sku, stock, poriginal, ppromocion, product_id, variant_id, tienda_id, created_at, updated_at FROM tiendanube WHERE producto_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildProducto $obj */
            $obj = new ChildProducto();
            $obj->hydrate($row);
            ProductoTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildProducto|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProductoTableMap::COL_PRODUCTO_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProductoTableMap::COL_PRODUCTO_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the producto_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProductoId(1234); // WHERE producto_id = 1234
     * $query->filterByProductoId(array(12, 34)); // WHERE producto_id IN (12, 34)
     * $query->filterByProductoId(array('min' => 12)); // WHERE producto_id > 12
     * </code>
     *
     * @param     mixed $productoId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByProductoId($productoId = null, $comparison = null)
    {
        if (is_array($productoId)) {
            $useMinMax = false;
            if (isset($productoId['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PRODUCTO_ID, $productoId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($productoId['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PRODUCTO_ID, $productoId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_PRODUCTO_ID, $productoId, $comparison);
    }

    /**
     * Filter the query on the sku column
     *
     * Example usage:
     * <code>
     * $query->filterBySku('fooValue');   // WHERE sku = 'fooValue'
     * $query->filterBySku('%fooValue%', Criteria::LIKE); // WHERE sku LIKE '%fooValue%'
     * </code>
     *
     * @param     string $sku The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterBySku($sku = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($sku)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_SKU, $sku, $comparison);
    }

    /**
     * Filter the query on the stock column
     *
     * Example usage:
     * <code>
     * $query->filterByStock(1234); // WHERE stock = 1234
     * $query->filterByStock(array(12, 34)); // WHERE stock IN (12, 34)
     * $query->filterByStock(array('min' => 12)); // WHERE stock > 12
     * </code>
     *
     * @param     mixed $stock The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByStock($stock = null, $comparison = null)
    {
        if (is_array($stock)) {
            $useMinMax = false;
            if (isset($stock['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_STOCK, $stock['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($stock['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_STOCK, $stock['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_STOCK, $stock, $comparison);
    }

    /**
     * Filter the query on the poriginal column
     *
     * Example usage:
     * <code>
     * $query->filterByPoriginal(1234); // WHERE poriginal = 1234
     * $query->filterByPoriginal(array(12, 34)); // WHERE poriginal IN (12, 34)
     * $query->filterByPoriginal(array('min' => 12)); // WHERE poriginal > 12
     * </code>
     *
     * @param     mixed $poriginal The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByPoriginal($poriginal = null, $comparison = null)
    {
        if (is_array($poriginal)) {
            $useMinMax = false;
            if (isset($poriginal['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PORIGINAL, $poriginal['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($poriginal['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PORIGINAL, $poriginal['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_PORIGINAL, $poriginal, $comparison);
    }

    /**
     * Filter the query on the ppromocion column
     *
     * Example usage:
     * <code>
     * $query->filterByPpromocion(1234); // WHERE ppromocion = 1234
     * $query->filterByPpromocion(array(12, 34)); // WHERE ppromocion IN (12, 34)
     * $query->filterByPpromocion(array('min' => 12)); // WHERE ppromocion > 12
     * </code>
     *
     * @param     mixed $ppromocion The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByPpromocion($ppromocion = null, $comparison = null)
    {
        if (is_array($ppromocion)) {
            $useMinMax = false;
            if (isset($ppromocion['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PPROMOCION, $ppromocion['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($ppromocion['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PPROMOCION, $ppromocion['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_PPROMOCION, $ppromocion, $comparison);
    }

    /**
     * Filter the query on the product_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProductId(1234); // WHERE product_id = 1234
     * $query->filterByProductId(array(12, 34)); // WHERE product_id IN (12, 34)
     * $query->filterByProductId(array('min' => 12)); // WHERE product_id > 12
     * </code>
     *
     * @param     mixed $productId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByProductId($productId = null, $comparison = null)
    {
        if (is_array($productId)) {
            $useMinMax = false;
            if (isset($productId['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PRODUCT_ID, $productId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($productId['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_PRODUCT_ID, $productId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_PRODUCT_ID, $productId, $comparison);
    }

    /**
     * Filter the query on the variant_id column
     *
     * Example usage:
     * <code>
     * $query->filterByVariantId(1234); // WHERE variant_id = 1234
     * $query->filterByVariantId(array(12, 34)); // WHERE variant_id IN (12, 34)
     * $query->filterByVariantId(array('min' => 12)); // WHERE variant_id > 12
     * </code>
     *
     * @param     mixed $variantId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByVariantId($variantId = null, $comparison = null)
    {
        if (is_array($variantId)) {
            $useMinMax = false;
            if (isset($variantId['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_VARIANT_ID, $variantId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($variantId['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_VARIANT_ID, $variantId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_VARIANT_ID, $variantId, $comparison);
    }

    /**
     * Filter the query on the tienda_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTiendaId(1234); // WHERE tienda_id = 1234
     * $query->filterByTiendaId(array(12, 34)); // WHERE tienda_id IN (12, 34)
     * $query->filterByTiendaId(array('min' => 12)); // WHERE tienda_id > 12
     * </code>
     *
     * @see       filterByTienda()
     *
     * @param     mixed $tiendaId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByTiendaId($tiendaId = null, $comparison = null)
    {
        if (is_array($tiendaId)) {
            $useMinMax = false;
            if (isset($tiendaId['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_TIENDA_ID, $tiendaId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($tiendaId['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_TIENDA_ID, $tiendaId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_TIENDA_ID, $tiendaId, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(ProductoTableMap::COL_UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(ProductoTableMap::COL_UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductoTableMap::COL_UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query by a related \Tienda object
     *
     * @param \Tienda|ObjectCollection $tienda The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProductoQuery The current query, for fluid interface
     */
    public function filterByTienda($tienda, $comparison = null)
    {
        if ($tienda instanceof \Tienda) {
            return $this
                ->addUsingAlias(ProductoTableMap::COL_TIENDA_ID, $tienda->getTiendaId(), $comparison);
        } elseif ($tienda instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProductoTableMap::COL_TIENDA_ID, $tienda->toKeyValue('PrimaryKey', 'TiendaId'), $comparison);
        } else {
            throw new PropelException('filterByTienda() only accepts arguments of type \Tienda or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Tienda relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function joinTienda($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Tienda');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Tienda');
        }

        return $this;
    }

    /**
     * Use the Tienda relation Tienda object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \TiendaQuery A secondary query class using the current class as primary query
     */
    public function useTiendaQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinTienda($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Tienda', '\TiendaQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildProducto $producto Object to remove from the list of results
     *
     * @return $this|ChildProductoQuery The current query, for fluid interface
     */
    public function prune($producto = null)
    {
        if ($producto) {
            $this->addUsingAlias(ProductoTableMap::COL_PRODUCTO_ID, $producto->getProductoId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the tiendanube table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductoTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProductoTableMap::clearInstancePool();
            ProductoTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductoTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ProductoTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ProductoTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ProductoTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     $this|ChildProductoQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(ProductoTableMap::COL_UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     $this|ChildProductoQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(ProductoTableMap::COL_UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     $this|ChildProductoQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(ProductoTableMap::COL_UPDATED_AT);
    }

    /**
     * Order by create date desc
     *
     * @return     $this|ChildProductoQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(ProductoTableMap::COL_CREATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     $this|ChildProductoQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(ProductoTableMap::COL_CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date asc
     *
     * @return     $this|ChildProductoQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(ProductoTableMap::COL_CREATED_AT);
    }

} // ProductoQuery
