<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', true);

$start = microtime(true);
require_once '../src/propel.php';
require_once '../src/auxiliar.php';
include '../src/apiTN.php';
include '../src/auth.php';

$Tienda = auth();

if (!isset($_POST['pagina'])) {
    Aux::error('Unprocessable Entity', 422);
}

$pag = intval($_POST['pagina']);

if ($pag <= 0) {
    Aux::error('Unprocessable Entity', 422);
}

$params = array(
    // 'updated_at_max' => '2019-04-23T21:17:02+00:00',
    'page' => $pag,
    'per_page' => 100,
    'fields' => 'id,name,variants',
    'published' => 'true',
);

try {

    $out = array(
        'cant_actualizados' => 0,
        'cant_errores' => 0,
        'cant_omitidos' => 0,
        'errores' => array(),
        'duracion' => 0,
        'seguir' => true,
    );

    $api = new apiTN($Tienda->getTiendaId(), $Tienda->getAccessToken());

    $ProductosTN = $api->get_products($params);

    if (count($ProductosTN) < 100) {
        $out['seguir'] = false;
    }

    foreach ($ProductosTN as $key => $productoTN) {

        if (!isset($productoTN['variants'])) {
            $out['cant_omitidos'] = $out['cant_omitidos'] + 1;
            continue;
        }

        foreach ($productoTN["variants"] as $key2 => $variant) {
            $sku = $variant['sku'];

            if ($sku) {
                try {
                    $producto = ProductoQuery::create()->filterBySku($sku)->findOne();

                    if ($producto) {
                        //Actualizo los campos con las id de la variante y del producto.
                        $producto->setProductId($productoTN['id']);
                        $producto->setVariantId($variant['id']);
                        $producto->save();
                        $out['cant_actualizados'] = $out['cant_actualizados'] + 1;
                    } else {
                        $out['cant_omitidos'] = $out['cant_omitidos'] + 1;
                    }

                } catch (\Throwable $th) {
                    $out['cant_errores'] = $out['cant_errores'] + 1;
                    array_push($out['errores'], $sku);
                }
            } else {
                $out['cant_omitidos'] = $out['cant_omitidos'] + 1;
            }
        }
    }

    $out['duracion'] = microtime(true) - $start;
    Aux::exito($out, 200);
    exit;

} catch (Exception $e) {
    Aux::error('Error al sincronizar productos.', 500, $e);
}
