<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', true);

$start = microtime(true);
require_once '../src/propel.php';
require_once '../src/auxiliar.php';
require_once '../src/parallelcurl.php';
include '../src/apiTN.php';
include '../src/auth.php';

function go($productos)
{
    $Tienda = auth();

    global $out;

    $out = array(
        'cant_actualizados' => 0,
        'cant_errores' => 0,
        'cant_omitidos' => 0,
        'errores' => array(),
        'headers' => array(),
        'duracion' => 0,
        'seguir' => true,
    );

    if (count($productos) == 0) {
        $out['seguir'] = false;
    }

    function on_request_done($response, $url, $ch, $params)
    {
        global $out;
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($httpcode !== 200) {
            $out['cant_errores'] = $out['cant_errores'] + 1;
            array_push($out['errores'], $params['sku']);
            return;
        }

        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $headers_string = substr($response, 0, $header_size);
        $body = substr($response, $header_size);

        $headers = array();
        array_push($headers, ApiTn::obtenerHeader('X-Total-Count', $headers_string));
        array_push($headers, ApiTn::obtenerHeader('X-Rate-Limit-Limit', $headers_string));
        array_push($headers, ApiTn::obtenerHeader('X-Rate-Limit-Remaining', $headers_string));
        $out['cant_actualizados'] = $out['cant_actualizados'] + 1;
        $out['headers'] = $headers;
    }

    $mh = curl_multi_init();

    $api = new apiTN($Tienda->getTiendaId(), $Tienda->getAccessToken());

    $headers = array(
        'Content-Type: application/json',
        sprintf('Authentication: bearer %s', $api->client_secret),
    );

    $curl_options = array(
        CURLOPT_RETURNTRANSFER => true, // return web page
        CURLOPT_HEADER => 1, // don't return headers
        CURLINFO_HEADER_OUT => false,
        CURLOPT_CUSTOMREQUEST => "PUT",
        CURLOPT_VERBOSE => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_FOLLOWLOCATION => true, // follow redirects
        CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
        CURLOPT_USERAGENT => $api->user_agent, // name of client
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => 0,
        CURLOPT_CAINFO => getcwd() . CRT_FILE,
        CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
        CURLOPT_TIMEOUT => 120, // time-out on response
    );
    $parallel_curl = new ParallelCurl(10, $curl_options);

    foreach ($productos as $key => $prod) {

        $params = array(
            'sku' => $prod->getSku(),
            'stock_management' => true,
            'stock' => $prod->getStock(),
            'price' => $prod->getPoriginal(),
            'promotional_price' => $prod->getPpromocion(),
        );

        $action = "/products" . "/" . $prod->getProductId() . "/variants" . "/" . $prod->getVariantId();
        $url = $api->api_url . $api->client_id . $action;
        $parallel_curl->startRequest($url, 'on_request_done', $params);
    }

    $parallel_curl->finishAllRequests();
    return $out;

}

try {
    $productos = ProductoQuery::create()
        ->where('product_id is not null')
        ->where('variant_id is not null')
        ->orderByProductoId('asc')
        ->offset(0)
        ->limit(5)
        ->find();

    $out = go($productos);
    $out['duracion'] = microtime(true) - $start;
    Aux::exito($out, 200);
    exit;

} catch (\Throwable $th) {
    throw $th;
}
