<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

const RETURN_URL = 'http://localhost:81/ferrenet/';

require_once '../src/propel.php';
include '../src/apiTN.php';
include '../src/auxiliar.php';

session_start();
unset($_SESSION['authenticated']);
unset($_SESSION['store_id']);
// const APP_ID = 847;

//Recupero el codigo de ingreso.
if (isset($_GET["code"])) {
    // echo 'code ' . $_GET["code"];
    $result = apiTN::registrar($_GET["code"]);
} else {
    trigger_error('No se recibio ningun codigo');
}

// var_dump($result);

if (isset($result['error'])) {
    //Error!
    Aux::error('Error al autorizar la app ', 401, $result);
}

if (!$result) {
    Aux::error('Error al autorizar la app ', 401);
}

$tienda_id = $result['user_id'];
$access_token = $result['access_token'];

if (!($tienda_id && $access_token)) {
    //Error!
    Aux::error("Error al autorizar la app", 401, $result);
}

try {

    $api = new apiTN($tienda_id, $access_token);
    try {
        $Tienda = TiendaQuery::create()->findPk($tienda_id);
        echo 'Tienda: \n';
        var_dump($Tienda);

        //code...
    } catch (\Throwable $th) {
        //throw $th;
        var_dump($th);
        Aux::error('error propel', "Location: https://www.tiendanube.com/apps/" . APP_ID . "/authorize");
    }

    if ($Tienda) {
        $Tienda->setAccessToken($access_token);
    } else {
        $Tienda = new Tienda();
        $Tienda->setTiendaId($tienda_id);
        $Tienda->setAccessToken($access_token);

        $params = array(
            'fields' => 'id,name',
        );

        $TiendaTN = $api->get_store($params);

        if (isset($TiendaTN['code']) && $TiendaTN['code'] != 200) {
            Aux::error('Error al registrar tienda.' . $TiendaTN['error'], "Location: https://www.tiendanube.com/apps/" . APP_ID . "/authorize", $TiendaTN);
            exit;
        } else {
            $Tienda->setNombre($TiendaTN['name']['es']);
        }
    }

    $Tienda->save(); //Grabo la Tienda
    //Autentico al usuario y defino el id de usuario.
    $_SESSION['authenticated'] = true;
    $_SESSION['store_id'] = $tienda_id;

    // header("Location: http://" . $_SERVER['HTTP_HOST'] . "/");
    header('Location: ' . RETURN_URL);
    exit;
} catch (Exception $e) {
    Aux::error('Error en login', 500, $e);
}
