<?php
$start = microtime(true);

require_once '../src/propel.php';
require_once '../src/auxiliar.php';
include '../src/auth.php';
include '../src/apiTN.php';

$Tienda = auth();

$out = array(
    'cant_total' => 0,
    'cant_total_tn' => 0,
    'cant_sincronizados' => 0,
    'duracion' => 0,
);

$api = new apiTN($Tienda->getTiendaId(), $Tienda->getAccessToken());

$params = array(
    'page' => 1,
    'per_page' => 1,
    'fields' => 'id',
    'published' => 'true',
);

$prods_tn = $api->get_products($params);

if (isset($prods_tn['headers'])) {
    $out['headers'] = $prods_tn['headers'];
}

$out['cant_total'] = ProductoQuery::create()->count();
$out['cant_sincronizados'] = ProductoQuery::create()
    ->where('product_id is not null')
    ->where('variant_id is not null')
    ->count();
$out['duracion'] = microtime(true) - $start;
Aux::exito($out, 200);
